import pytest
import requests

url = "http://127.0.0.1"
port = "8000"

def test_servidor_rodando():
    try:
        r = requests.head(url+':'+port)
        assert r.status_code == 200, f'O servidor devolveu uma resposta diferente da esperada: {r.status_code}'
    except requests.exceptions.ConnectionError:
        raise AssertionError(f'O servidor não está executando corretamente. Verifique se você consegue acessá-lo no navegador pelo endereço {url}.')

def test_conteudo_index_correto():
    try:
        r = requests.get(url+':'+port)
        assert r.text == 'Olá mundo! Este é o app notes de DevLife do Insper.', f'O servidor devolveu uma resposta diferente da esperada: {r.text}'
    except requests.exceptions.ConnectionError:
        raise AssertionError(f'O servidor não está executando corretamente. Verifique se você consegue acessá-lo no navegador pelo endereço {url}.')

def test_conteudo_notes_correto():
    try:
        r = requests.get(url+':'+port+"/notes/")
        assert r.text == 'Olá mundo! Este é o app notes de DevLife do Insper.'
    except requests.exceptions.ConnectionError:
        raise AssertionError(f'O servidor não está executando corretamente. Verifique se você consegue acessá-lo no navegador pelo endereço {url}.')
